/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.AbstractDiligentForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;

public class DiligentForm
extends AbstractDiligentForm {
    public static final Codec<DiligentForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("from_frame_block").forGetter(o -> o.fromFrameBlock), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("area_block").forGetter(o -> o.areaBlock), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("to_frame_block").forGetter(o -> o.toFrameBlock), (App)Codec.BOOL.fieldOf("generate_frame_if_not_found").forGetter(o -> o.generateFrameIfNotFound)).apply((Applicative)instance, instance.stable(DiligentForm::new)));
    public final Block fromFrameBlock;
    public final Block areaBlock;
    public final Block toFrameBlock;

    public DiligentForm(Block fromFrameBlock, Block areaBlock, Block toFrameBlock, boolean generateFrameIfNotFound) {
        super(generateFrameIfNotFound);
        this.fromFrameBlock = fromFrameBlock;
        this.areaBlock = areaBlock;
        this.toFrameBlock = toFrameBlock;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return new DiligentForm(this.toFrameBlock, this.areaBlock, this.fromFrameBlock, this.generateFrameIfNotFound);
    }

    @Override
    public void generateNewFrame(ServerLevel fromWorld, BlockPortalShape fromShape, ServerLevel toWorld, BlockPortalShape toShape) {
        for (BlockPos blockPos : toShape.frameAreaWithCorner) {
            toWorld.m_46597_(blockPos, this.toFrameBlock.m_49966_());
        }
    }

    @Override
    public Predicate<BlockState> getOtherSideFramePredicate() {
        return s -> s.m_60734_() == this.toFrameBlock;
    }

    @Override
    public Predicate<BlockState> getThisSideFramePredicate() {
        return s -> s.m_60734_() == this.fromFrameBlock;
    }

    @Override
    public Predicate<BlockState> getAreaPredicate() {
        return s -> s.m_60734_() == this.areaBlock;
    }
}

